// ShareRecordDialog.cpp : implementation file
//

#include "stdafx.h"
#include "SC510.h"
#include "SC510Dlg.h"
#include "ShareRecordDialog.h"
#include "afxdialogex.h"

// CShareRecordDialog dialog

IMPLEMENT_DYNAMIC(CShareRecordDialog, CDialog)

CShareRecordDialog::CShareRecordDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CShareRecordDialog::IDD, pParent)
{

}

CShareRecordDialog::~CShareRecordDialog()
{
}

void CShareRecordDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CShareRecordDialog)
	DDX_Control(pDX, IDC_SHARE_DISPLAY_STATIC, m_staticShareWindow);
	DDX_Control(pDX, IDC_SHARE_CHECK, m_shareCheckGPU1);
	DDX_Control(pDX, IDC_SHARE_STOP_BUTTON, m_btnShareRecordStop1);
	DDX_Control(pDX, IDC_SHARE_START_BUTTON, m_btnShareRecordStart1);
	DDX_Control(pDX, IDC_SHARE_EDIT, m_editShareRecord);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CShareRecordDialog, CDialog)
	//{{AFX_MSG_MAP(CShareRecordDialog)
	ON_BN_CLICKED(IDC_SCFA_SHARE_RADIO, OnScfAShareRadio)
	ON_BN_CLICKED(IDC_SCFB_SHARE_RADIO, OnScfBShareRadio)
	ON_BN_CLICKED(IDC_CH1_RADIO, OnCh1Radio)
	ON_BN_CLICKED(IDC_CH2_RADIO, OnCh2Radio)
	ON_BN_CLICKED(IDC_CH3_RADIO, OnCh3Radio)
	ON_BN_CLICKED(IDC_CH4_RADIO, OnCh4Radio)
	ON_BN_CLICKED(IDC_SHARE_START_BUTTON, OnShareStartButton)
	ON_BN_CLICKED(IDC_SHARE_STOP_BUTTON, OnShareStopButton)
	ON_BN_CLICKED(IDC_OK_BUTTON, OnOkButton)
	ON_WM_DESTROY()
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// CShareRecordDialog message handlers

BOOL CShareRecordDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	m_btnShareRecordStart1.EnableWindow( TRUE );

	m_btnShareRecordStop1.EnableWindow( FALSE );

	CString strFullPath = m_pMainDialog->GetWorkingPath( "08_SHARE.SCF" );

	m_editShareRecord.SetWindowText( (LPCTSTR)strFullPath );

	CheckDlgButton( IDC_SCFA_SHARE_RADIO, BST_CHECKED );

	CheckDlgButton( IDC_SCFB_SHARE_RADIO, BST_UNCHECKED );

	BOOL bIsNoSignal = TRUE;

	// CONFIRM WHETHER HAVE SIGNAL TO RELEVANT INPUT CHANNEL
	//
	for ( ULONG i = 0 ; i < DEFAULT_MAX_CHANNEL_NUM ; i++ ) 
	{
		if ( i == 0 ) 
		{
			if ( m_pMainDialog->m_nVideoWidth[ i ] != 0 ) 
			{
				CheckDlgButton( IDC_CH1_RADIO, BST_CHECKED );

				CheckDlgButton( IDC_CH2_RADIO, BST_UNCHECKED );

				CheckDlgButton( IDC_CH3_RADIO, BST_UNCHECKED );

				CheckDlgButton( IDC_CH4_RADIO, BST_UNCHECKED );

				bIsNoSignal = FALSE;
			}
		}
		
		if ( i == 1 ) 
		{
			if ( m_pMainDialog->m_nVideoWidth[ i ] != 0 ) 
			{
				CheckDlgButton( IDC_CH2_RADIO, BST_CHECKED );

				CheckDlgButton( IDC_CH1_RADIO, BST_UNCHECKED );

				CheckDlgButton( IDC_CH3_RADIO, BST_UNCHECKED );

				CheckDlgButton( IDC_CH4_RADIO, BST_UNCHECKED );

				bIsNoSignal = FALSE;
			}
		}
		
		if ( i == 2 ) 
		{
			if ( m_pMainDialog->m_nVideoWidth[ i ] != 0 ) 
			{
				CheckDlgButton( IDC_CH3_RADIO, BST_CHECKED );

				CheckDlgButton( IDC_CH2_RADIO, BST_UNCHECKED );

				CheckDlgButton( IDC_CH1_RADIO, BST_UNCHECKED );

				CheckDlgButton( IDC_CH4_RADIO, BST_UNCHECKED );

				bIsNoSignal = FALSE;
			}
		}

		if ( i == 3 ) 
		{
			if ( m_pMainDialog->m_nVideoWidth[ i ] != 0 ) 
			{
				CheckDlgButton( IDC_CH4_RADIO, BST_CHECKED );

				CheckDlgButton( IDC_CH2_RADIO, BST_UNCHECKED );

				CheckDlgButton( IDC_CH3_RADIO, BST_UNCHECKED );

				CheckDlgButton( IDC_CH1_RADIO, BST_UNCHECKED );

				bIsNoSignal = FALSE;
			}
		}		
	}

	if ( bIsNoSignal ) 
	{	
		CheckDlgButton( IDC_CH4_RADIO, BST_UNCHECKED );

		CheckDlgButton( IDC_CH2_RADIO, BST_UNCHECKED );

		CheckDlgButton( IDC_CH3_RADIO, BST_UNCHECKED );

		CheckDlgButton( IDC_CH1_RADIO, BST_UNCHECKED );	
	}

	for ( ULONG i = 0; i < DEFAULT_MAX_CHANNEL_NUM ; i++ ) 
	{		
		if ( i == 0 ) 
		{			
			if ( m_pMainDialog->m_hVideoDevice[ i ] != NULL ) 
			{				
				GetDlgItem( IDC_CH1_RADIO )->EnableWindow( TRUE );
			}
			else 
			{			
				GetDlgItem( IDC_CH1_RADIO )->EnableWindow( FALSE );
			}
		}

		if ( i == 1 ) 
		{			
			if ( m_pMainDialog->m_hVideoDevice[ i ] != NULL ) 
			{
				GetDlgItem( IDC_CH2_RADIO )->EnableWindow( TRUE );
			}
			else 
			{			
				GetDlgItem( IDC_CH2_RADIO )->EnableWindow( FALSE );
			}
		}

		if ( i == 2 ) 
		{			
			if ( m_pMainDialog->m_hVideoDevice[ i ] != NULL ) 
			{
				GetDlgItem( IDC_CH3_RADIO )->EnableWindow( TRUE );
			}
			else {
			
				GetDlgItem( IDC_CH3_RADIO )->EnableWindow( FALSE );
			}
		}

		if ( i == 3 ) 
		{			
			if ( m_pMainDialog->m_hVideoDevice[ i ] != NULL ) 
			{
				GetDlgItem( IDC_CH4_RADIO )->EnableWindow( TRUE );
			}
			else 
			{			
				GetDlgItem( IDC_CH4_RADIO )->EnableWindow( FALSE );
			}			
		}
	}

	SetTimer( 0x00000001, 100, NULL );

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CShareRecordDialog::OnScfAShareRadio() 
{
	// TODO: Add your control notification handler code here
	
	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	CString strFullPath = m_pMainDialog->GetWorkingPath( "08_SHARE.SCF" );

	m_editShareRecord.SetWindowText( (LPCTSTR)strFullPath );

	UINT iCheckedSCFA_1_1, iCheckedSCFB_1_1;

	iCheckedSCFA_1_1 = ((CButton*)GetDlgItem( IDC_SCFA_SHARE_RADIO ))->GetCheck();

	iCheckedSCFB_1_1 = ((CButton*)GetDlgItem( IDC_SCFB_SHARE_RADIO ))->GetCheck();

	if( iCheckedSCFA_1_1 ) { ((CButton*)GetDlgItem( IDC_SCFA_SHARE_RADIO ))->SetCheck( TRUE ); }

	if( iCheckedSCFB_1_1 ) { ((CButton*)GetDlgItem( IDC_SCFB_SHARE_RADIO ))->SetCheck( TRUE ); }
}

void CShareRecordDialog::OnScfBShareRadio() 
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	CString strFullPath = m_pMainDialog->GetWorkingPath( "08_SHARE.SCF" );

	m_editShareRecord.SetWindowText( (LPCTSTR)strFullPath );

	UINT iCheckedSCFA_1_1, iCheckedSCFB_1_1;

	iCheckedSCFA_1_1 = ((CButton*)GetDlgItem( IDC_SCFA_SHARE_RADIO ))->GetCheck();

	iCheckedSCFB_1_1 = ((CButton*)GetDlgItem( IDC_SCFB_SHARE_RADIO ))->GetCheck();

	if ( iCheckedSCFA_1_1 ) { ((CButton*)GetDlgItem( IDC_SCFA_SHARE_RADIO ))->SetCheck( TRUE ); }

	if ( iCheckedSCFB_1_1 ) { ((CButton*)GetDlgItem( IDC_SCFB_SHARE_RADIO ))->SetCheck( TRUE ); }	
}

void CShareRecordDialog::OnCh1Radio() 
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	m_pMainDialog->m_bShareRecordCH[ 0 ] = TRUE;
		
	m_pMainDialog->m_bShareRecordCH[ 1 ] = FALSE;
	
	m_pMainDialog->m_bShareRecordCH[ 2 ] = FALSE;
	
	m_pMainDialog->m_bShareRecordCH[ 3 ] = FALSE;
}

void CShareRecordDialog::OnCh2Radio() 
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	m_pMainDialog->m_bShareRecordCH[ 0 ] = FALSE;
		
	m_pMainDialog->m_bShareRecordCH[ 1 ] = TRUE;
	
	m_pMainDialog->m_bShareRecordCH[ 2 ] = FALSE;
	
	m_pMainDialog->m_bShareRecordCH[ 3 ] = FALSE;	
}

void CShareRecordDialog::OnCh3Radio() 
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	m_pMainDialog->m_bShareRecordCH[ 0 ] = FALSE;
		
	m_pMainDialog->m_bShareRecordCH[ 1 ] = FALSE;
	
	m_pMainDialog->m_bShareRecordCH[ 2 ] = TRUE;
	
	m_pMainDialog->m_bShareRecordCH[ 3 ] = FALSE;	
}

void CShareRecordDialog::OnCh4Radio() 
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	m_pMainDialog->m_bShareRecordCH[ 0 ] = FALSE;
		
	m_pMainDialog->m_bShareRecordCH[ 1 ] = FALSE;
	
	m_pMainDialog->m_bShareRecordCH[ 2 ] = FALSE;
	
	m_pMainDialog->m_bShareRecordCH[ 3 ] = TRUE;	
}

void CShareRecordDialog::OnShareStartButton() 
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	m_btnShareRecordStart1.EnableWindow( FALSE );

	m_btnShareRecordStop1.EnableWindow( TRUE );

	GetDlgItem(IDC_OK_BUTTON)->EnableWindow( FALSE );

	m_pMainDialog->m_bShareSupportGPU1_1 = m_shareCheckGPU1.GetCheck();

	INT nChannelNum = -1;

	if( ((CButton*)GetDlgItem( IDC_CH1_RADIO ))->GetCheck() ) { nChannelNum = 0; }

	if( ((CButton*)GetDlgItem( IDC_CH2_RADIO ))->GetCheck() ) { nChannelNum = 1; }

	if( ((CButton*)GetDlgItem( IDC_CH3_RADIO ))->GetCheck() ) { nChannelNum = 2; }

	if( ((CButton*)GetDlgItem( IDC_CH4_RADIO ))->GetCheck() ) { nChannelNum = 3; }

	if( nChannelNum == -1 ) { return; }

	for( INT i = 0 ; i < 4 ; i++ )  {	

		if( i == nChannelNum ) {	

			m_pMainDialog->m_bShareRecordCH[ i ] = TRUE;
		}
	}

	ULONG  nVideoWidth = m_pMainDialog->m_nVideoWidth[ nChannelNum ];

	ULONG  nVideoHeight =  m_pMainDialog->m_nVideoHeight[ nChannelNum ];

	double dVideoFrameRate = m_pMainDialog->m_dVideoFrameRate[ nChannelNum ];

	UINT   iCheckedSCFA, iCheckedSCHB;

	iCheckedSCFA = IsDlgButtonChecked( IDC_SCFA_SHARE_RADIO );

	iCheckedSCHB = IsDlgButtonChecked( IDC_SCFB_SHARE_RADIO );

	if( iCheckedSCFA == BST_CHECKED ) {		

		QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY( 8, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM, 2, 16, 48000 );
	}

	if( iCheckedSCHB == BST_CHECKED ) {

		QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY( 8, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, 2, 16, 48000 );
	}

	if( m_pMainDialog->m_bShareSupportGPU1_1 ) {

		QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 8, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, MAKEFOURCC('Y', 'V', '1', '2'), nVideoWidth, nVideoHeight, dVideoFrameRate, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, m_staticShareWindow.m_hWnd, 1 );

		//QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 8, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, MAKEFOURCC('Y', 'U', 'Y', '2'), nVideoWidth, nVideoHeight, dVideoFrameRate, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, m_staticShareWindow.m_hWnd, 1 );
	}
	else {		

		QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 8, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, MAKEFOURCC('Y', 'V', '1', '2'), nVideoWidth, nVideoHeight, dVideoFrameRate, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, m_staticShareWindow.m_hWnd, 1 );

		//QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 8, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, MAKEFOURCC('Y', 'U', 'Y', '2'), nVideoWidth, nVideoHeight, dVideoFrameRate, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, m_staticShareWindow.m_hWnd, 1 );
	}

	CString strFullPath;
	
	if( iCheckedSCFA == BST_CHECKED ) {

		strFullPath = m_pMainDialog->GetWorkingPath( "08_SHARE.SCF" );
	}
	if( iCheckedSCHB == BST_CHECKED ) {

		strFullPath = m_pMainDialog->GetWorkingPath( "08_SHARE.SCF" );
	}

	ULONG nStrlen = strFullPath.GetLength();

	CHAR * psz = strFullPath.GetBuffer( nStrlen + 1 );	

	if ( m_pMainDialog->m_hVideoDevice[ 4 ] != NULL )
	{
		QCAP_START_SHARE_RECORD( 8, psz, QCAP_RECORD_FLAG_FULL, 0, 0, 3600 );
	}

	strFullPath.ReleaseBuffer();	

	m_pMainDialog->m_bIsShareRecord = TRUE;	
}

void CShareRecordDialog::OnShareStopButton()
{
	// TODO: Add your control notification handler code here

	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();	

	m_btnShareRecordStart1.EnableWindow( TRUE );

	m_btnShareRecordStop1.EnableWindow( FALSE );

	GetDlgItem( IDC_OK_BUTTON )->EnableWindow( TRUE );

	QCAP_STOP_SHARE_RECORD( 8 );

	m_pMainDialog->m_bIsShareRecord = FALSE;
}

void CShareRecordDialog::OnOkButton() 
{
	// TODO: Add your control notification handler code here
	
	CDialog::OnOK();
}

void CShareRecordDialog::OnDestroy() 
{
	CDialog::OnDestroy();

	// TODO: Add your message handler code here

	KillTimer( 0x00000001 );

	OnShareStopButton();	
}

void CShareRecordDialog::OnTimer(UINT_PTR nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	
	CSC510Dlg * m_pMainDialog = (CSC510Dlg *)AfxGetMainWnd();

	if ( nIDEvent == 0x00000001 ) 
	{
		CTime time( CTime::GetCurrentTime() );

		SYSTEMTIME timeDest; time.GetAsSystemTime( timeDest );

		SYSTEMTIME s_system_times_;  GetSystemTime( &s_system_times_ );

		s_system_times_.wYear = timeDest.wYear;

		s_system_times_.wDayOfWeek = timeDest.wDayOfWeek;

		s_system_times_.wMonth = timeDest.wMonth;

		s_system_times_.wDay = timeDest.wDay;

		s_system_times_.wHour = timeDest.wHour;

		CHAR pszTimeText[ MAX_PATH ] = { 0 };

		sprintf( pszTimeText, "%04d-%02d-%02d %02d:%02d:%02d:%04d", s_system_times_.wYear,  s_system_times_.wMonth, s_system_times_.wDay, s_system_times_.wHour, s_system_times_.wMinute, s_system_times_.wSecond, s_system_times_.wMilliseconds );

		if ( m_pMainDialog->m_hVideoDevice[ 4 ] != NULL )
		{
			QCAP_SET_OSD_SHARE_RECORD_TEXT_EX( 8, 0, 0, 0, -1, -1, pszTimeText, "Arial", QCAP_FONT_STYLE_BOLD, 48, 0xFFFF0000, 0xFFFFFFFF, 0,0,255, 0, 0, QCAP_STRING_ALIGNMENT_STYLE_LEFT, QCAP_SEQUENCE_STYLE_FOREMOST );
		}
	}
}